"""Fixperms class for WP3"""
from fixperms_base import PermMap
from fixperms_ids import IDCache
from fixperms_cli import Args


class WP3PermMap(PermMap):
    """Fixperms class for WP3"""

    def __init__(self, ids: IDCache, args: Args):
        super().__init__(
            ids=ids,
            args=args,
            user='wordpress',
            all_docroots=['/home/wordpress/doc_root'],
            docroot_chmod=0o755,
            docroot_chown=('wordpress', 'wordpress'),
        )
        # pylint: disable=duplicate-code
        # Order these rules more specific to less specific regex.
        uid, gid = self.uid, self.gid
        # sensitive passwords: ~/.accesshash, ~/.pgpass, ~/.my.cnf
        self.add_rule(r"\/\.(?:pgpass|my\.cnf)$", (0o600, None), (uid, gid))
        # ~/.imh/nginx - ngxconf & cache manager files
        self.add_rule(r"\/\.imh\/nginx(?:$|\/)", (0o664, 0o775), (uid, gid))
        # ~/.imh directory and contents
        self.add_rule(r"\/\.imh(?:$|\/)", (0o644, 0o755), (0, 0))
        # ~/.ssh directory and contents
        self.add_rule(r"\/\.ssh(?:$|\/)", (0o600, 0o700), (uid, gid))
        # ~/.pki dir and subdirs
        self.add_rule(r"\/\.pki(?:$|\/)", (None, 0o740), (uid, gid))
        # ~/boldgrid_backup and contents
        self.add_rule(r"\/boldgrid_backup(?:$|\/)", (0o644, 0o700), (uid, gid))
        # .cgi and .pl files
        self.add_rule(r"\/.*\.(?:pl|cgi)$", (0o755, None), (uid, gid))
        # homedir folder itself
        self.add_rule("$", (None, 0o711), (uid, gid))
        # restrict access to wp-config.php
        self.add_rule(r"\/(?:.+\/)?wp-config\.php$", (0o640, None), (uid, gid))
        # ansible and its tmp
        self.add_rule(r"\/\.ansible(?:\/tmp)?$", (None, 0o700), (uid, gid))
        # contents of homedir which do not match a previous regex
        self.add_rule(r"\/", (0o644, 0o755), (uid, gid))
