![Plugin Banner](https://s3.amazonaws.com/foogallery/banner-772x250.jpg)

[![Scrutinizer Code Quality](https://scrutinizer-ci.com/g/fooplugins/foogallery/badges/quality-score.png?b=develop)](https://scrutinizer-ci.com/g/fooplugins/foogallery/?branch=develop)
# Foo Gallery #
**Contributors:** bradvin, fooplugins

**Donate link:** http://fooplugins.com

**Tags:** gallery, image gallery, photo gallery, responsive, album, media gallery, masonry gallery, portfolio, justified image gallery, video gallery, photography, photographer, retina

**Requires at least:** 3.9

**Tested up to:** 4.6.1

**Stable tag:** trunk

**License:** GPLv2 or later

**License URI:** http://www.gnu.org/licenses/gpl-2.0.html


Foo Gallery is the most intuitive and extensible gallery management tool ever created for WordPress.

## Description ##

Foo Gallery allows for better image and video gallery management within WordPress. Built to be simple for users and highly flexible for developers.

[View the Foo Gallery Homepage & DEMO](http://foo.gallery/)

**Retina Support**

Foo Gallery now comes with built-in support for higher quality thumbnails on retina-enabled displays. No more blurry thumbnails, just crisp thumbnails that look amazing on all devices.

**Video Support**

Foo Gallery now supports the creation of video galleries with the [FooVideo premium extension](http://fooplugins.com/plugins/foovideo/?utm_source=foogalleryplugin&utm_medium=foogallerylink&utm_campaign=foogallery_wprepo)! Create galleries with both images and videos mixed!

**Albums Built In**

Albums are now built in as an extension. Simply head over to the extensions page and activate the albums extension. A new menu item will appear that allows you to add albums just as easily as galleries.

**Built For Developers**

Foo Gallery was designed to be the most developer-friendly gallery plugin available for WordPress. It was also built on top of a solid extension framework, which means different functionality is separated out into different areas in the codebase. It also means the core plugin is lightweight, but still allowing for the most flexibility.

**Features**

*   Retina thumbnail support
*   Add videos to galleries (via the [FooVideo premium extension](http://fooplugins.com/plugins/foovideo/?utm_source=foogalleryplugin&utm_medium=foogallerylink&utm_campaign=foogallery_wprepo))
*	Albums built-in! (Activate the albums extension)
*	Gallery custom post type
*	Use built-in media library to manage images
*	Drag n Drop reordering of images and galleries
*	Built-in gallery templates
*	Built-in support for FooBox
*	Built-in Extensions Store
*	Built on an extension framework
*	Custom CSS for both galleries and albums
*	Copy to clipboard shortcodes
*	Visual shortcodes in rich text editor
*	Gallery picker to insert shortcode
*	Page usage metabox with one-click gallery page creation
*	NextGen importer tool (albums and galleries)
*	Multisite Support
*	plus many, many more

**Gallery Demos**

*	Responsive Image Gallery - [demo](http://foo.gallery/demos/responsive-image-gallery/)
*	FooGrid Image Gallery - [light demo](http://foo.gallery/demos/foogrid-light/) - [dark demo](http://foo.gallery/demos/foogrid-dark/)
*	Image Viewer Gallery - [light demo](http://foo.gallery/demos/image-viewer-gallery/) - [dark demo](http://foo.gallery/demos/image-viewer-gallery-dark/)
*	Masonry Gallery - [demo](http://foo.gallery/demos/masonry-image-gallery/)
*	Simple Portfolio - [demo](http://foo.gallery/demos/simple-portfolio/)
*	Justified Gallery ([http://miromannino.github.io/Justified-Gallery](http://miromannino.github.io/Justified-Gallery/)) - [demo](http://foo.gallery/demos/justified-gallery/)
*	Single Thumbnail Gallery - [demo](http://foo.gallery/demos/single-thumbnail-gallery/)
*	Polaroid Gallery - [demo](http://foo.gallery/demos/polaroid-image-gallery/)
*	Cube Gallery - [demo](http://foo.gallery/demos/cube-gallery/) - [Buy Now!](http://fooplugins.com/plugins/cube-gallery-template/?utm_source=foogalleryplugin&utm_medium=foogallerylink&utm_campaign=foogallery_wprepo)
*	Mixed (Images + Videos) - [demo](http://foo.gallery/demos/mixed/)

**Caption Demos**

*	Simple Hover Captions - [demo](http://foo.gallery/demos/captions-simple-hover/)
*	Always Visible Captions - [demo](http://foo.gallery/demos/responsive-image-gallery-captions/)
*	Drop Captions - [demo](http://foo.gallery/demos/captions-drop/)
*	Fade Captions - [demo](http://foo.gallery/demos/captions-fade/)
*	Push Captions - [demo](http://foo.gallery/demos/captions-push/)

**Album Demos**

*	Responsive Album Layout - [demo](http://foo.gallery/demos/responsive-album-layout/)
*	All-in-one Stack Album - [demo](http://foo.gallery/demos/all-in-one-stack-album/)

**Videos Demos**

*	Vertical Video Slider - [demo](http://foo.gallery/demos/video-slider-vertical/) - [full-width demo](http://foo.gallery/demos/video-slider-vertical-full-width/)
*	Horizontal Video Slider - [demo](http://foo.gallery/demos/video-slider-horizontal/) - [custom colors](http://foo.gallery/demos/video-slider-custom-theme/)

**Extensions**

*   [FooVideo](http://fooplugins.com/plugins/foovideo/?utm_source=foogalleryplugin&utm_medium=foogallerylink&utm_campaign=foogallery_wprepo)
*	Albums (bundled)
*	Default Gallery Templates (bundled)
*	NextGen Gallery and Album Importer (bundled)
*	[FooGrid Gallery](http://fooplugins.com/plugins/foogrid/?utm_source=foogalleryplugin&utm_medium=foogallerylink&utm_campaign=foogallery_wprepo)
*	[Cube Gallery](http://fooplugins.com/plugins/cube-gallery-template/?utm_source=foogalleryplugin&utm_medium=foogallerylink&utm_campaign=foogallery_wprepo)
*	[Custom Branding](http://fooplugins.com/plugins/foogallery-branding/?utm_source=foogalleryplugin&utm_medium=foogallerylink&utm_campaign=foogallery_wprepo)
*	[FooBox PRO Lightbox](http://fooplugins.com/plugins/foobox/?utm_source=foogalleryplugin&utm_medium=foogallerylink&utm_campaign=foogallery_wprepo)
*	[FooBox FREE Lightbox](http://wordpress.org/plugins/foobox-image-lightbox)
*	[Owl Carousel Template](http://wordpress.org/plugins/foogallery-owl-carousel-template/)
*	[ZOOM Template](http://wordpress.org/plugins/foogallery-zoom-template/)
*	[Thirsty Affiliates](http://wordpress.org/plugins/thirstyaffiliates-for-foogallery-extension/)
*	[Polaroid Template](https://github.com/fooplugins/foogallery-polaroid-template)
*	[Use Media Menu](https://github.com/fooplugins/foogallery-media-menu)
*	Build your own!!!

**Documentation**

*	[FooGallery 101](http://docs.fooplugins.com/foogallery/foogallery-101/)
*	[Developer 101](http://docs.fooplugins.com/foogallery/foogallery-developers-101/)
*	[Actions and Filters](http://docs.fooplugins.com/foogallery/actions-filters/)

**Contribute**

FooGallery is hosted on [GitHub](https://github.com/fooplugins/foogallery). If you find a bug, please [create an issue](https://github.com/fooplugins/foogallery/issues).

## Installation ##

1. Upload `foogallery` folder to the `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. You will be redirected to the FooGallery Help page to get your started

## Frequently Asked Questions ##

### Why are my thumbnails so blurry? ###

Have you enabled retina support for your galleries? Displays with retina support can show better quality thumbnails when retina support is enabled. To enable retina support, edit the gallery and locate the Retina Support metabox.

### Can I add videos to my galleries? ###

Yes, you need to use the [FooVideo premium extension](http://fooplugins.com/plugins/foovideo/?utm_source=foogalleryplugin&utm_medium=foogallerylink&utm_campaign=foogallery_wprepo)

### How do I get albums working? ###

Simply go to the FooGallery extensions page and activate the Albums extension. If you do not see a button to activate the albums extension, reload the extensions list by clicking the reload button.

### Can I build an extension? ###

Hell, yes! Check out our [developer page](http://foo.gallery/developers/)

## Screenshots ##

[View screenshots](https://wordpress.org/plugins/foogallery/screenshots/)

## Upgrade Notice ##

Update now to support FooVideo and many other improvements!

## Changelog ##

### 1.2.18 ###

* Fix : Handle no settings in retina metabox

### 1.2.17 ###

* New : Retina support - metabox per gallery and default settings
* New : Attachment datasources - backend changes for how images are used in a gallery. (This will allow for new external sources in the future)
* New : Caption color settings in Simple portfolio gallery template
* New : Updated to latest Justified Gallery
* Fix : Better wpthumb compatibility

### 1.2.16 ###

* Fix : Yoast SEO Sitemaps fatal error with deleted galleries
* Fix : Updating pages with deleted galleries throws php warnings

### 1.2.15 ###

* Fix : Album admin CSS issues in WP 4.6
* Fix : Masonry layout issues in WP 4.6
* Fix : Media attachment fields not updating
* Fix : Better support for IE10
* New : Thumbnail generation test admin notice and settings

### 1.2.13 ###

* Fix : Shortcode replacing content in visual editor
* Fix : Gallery hover effect of None being ignored
* New : ImageViewer language settings for 'Prev', 'Next' & 'of'
* New : Setting to use original thumbnails if available

### 1.2.12 ###

* Fix : Simple Portfolio missing captions fix

### 1.2.11 ###

* Fix : Simple Portfolio undefined function fix

### 1.2.10 ###

* New : support for multiple admin JS and CSS assets for gallery templates
* New : Added setting to choose Caption Description source
* New : Crop position can be chosen for attachments
* New : Albums gallery details modal for setting a gallery URL
* New : Better shortcode preview in editor
* New : Editor button now supported if multiple editors exist
* Fix : Better No-Link support for gallery templates
* Fix : Compatible with Unyson plugin
* Fix : Compatible with Advanced Custom Fields
* Fix : Simple Portfolio fixes and tweaks
* Fix : ImageViewer fixes and better browser compatibility
* Fix : Changed assets enqueue version to rather use extension version
* Fix : Album URL fix for permalinks with no trailing slashes

### 1.2.9 ###
* New : Added Image Viewer gallery template
* New : Caption support for default template
* New : Yoast SEO gallery image support!
* New : Responsive options for Masonry gallery
* New : change gallery URL slug for albums
* New : setting to turn off loading animation in default gallery
* New : French translation
* Fix : Support for WP 4.4
* Fix : All templates - moved all jQuery ready events to vanilla JS
* Fix : Many gallery template tweaks
* Fix : allow no default to be chosen in settings

### 1.2.8 ###
* Works now with Polylang translation plugin
* CSS Updates & enhancements to all gallery templates
* Password protected galleries now work as expected
* Ability to hide WYSIWYG editor button
* Updated WPThumb
* Multiple bug fixes and improvements

### 1.2.7 ###
* Bug fixes for 1.2.6 release
* Added 2 new settings to Justified Gallery template (maxRowHeight + Caption Source)

### 1.2.6 ###
* CSS load optimizations
* Updates and tweaks on all built-in gallery templates
* More robust extension loading
* More robust upgrades to FooBox PRO
* Improved copy-to-clipboard
* Added more hover effects
* Support for FooVideo

### 1.2.5 ###
* Fix for extensions being empty
* Added support for Multi-site
* Added esc_url to all places where url is rendered
* Updated to latest Justified Gallery v3.5.4

### 1.2.4 ###
* Many album template updates, enhancements and fixes
* Many gallery template tweaks and fixes
* Sort order settings for galleries and albums
* Added new Single Thumbnail Gallery template

### 1.2.1 ###
* Added setting to choose default gallery to copy settings from
* Fixed bug #45 - gallery fields not showing onload
* replaced minicolors with spectrum colorpicker
* Allow gallery fields to have a suffix
* Added function to render galleries "foogallery_render_gallery( $gallery_id )"

### 1.2.0 ###
* Added albums extension
* Added custom CSS metaboxes
* Updated Nextgen importer
* Fixed many bugs

### 1.1.8.2 ###
* Fixed "edit gallery" CSS with WP 4.0

### 1.1.8.1 ###
* Fixed "insert gallery" CSS with WP 4.0

### 1.1.8 ###
* Added 2 new gallery templates
* Added 10+ actions and filters for more customization
* Countless bug fixes and enhancements

### 1.1.7 ###
* first version!