<?php
/**
 * @package WPSEO\Admin
 */

/* translators: %1$s expands to Yoast SEO */
$wpseo_up_settings_header = sprintf( __( '%1$s settings', 'wordpress-seo' ), 'Yoast SEO' );

?>

<h2 id="wordpress-seo"><?php echo esc_html( $wpseo_up_settings_header ); ?></h2>

<table class="form-table">
	<tr>
		<th scope="row">
			<label
				for="wpseo_author_title"><?php esc_html_e( 'Title to use for Author page', 'wordpress-seo' ); ?></label>
		</th>
		<td>
			<input class="regular-text" type="text" id="wpseo_author_title" name="wpseo_author_title"
		           value="<?php echo esc_attr( get_the_author_meta( 'wpseo_title', $user->ID ) ); ?>"/>
		</td>
	</tr>
	<tr>
		<th scope="row">
			<label
				for="wpseo_author_metadesc"><?php esc_html_e( 'Meta description to use for Author page', 'wordpress-seo' ); ?></label>
		</th>
		<td>
			<textarea rows="3" cols="30" id="wpseo_author_metadesc"
			          name="wpseo_author_metadesc"><?php echo esc_textarea( get_the_author_meta( 'wpseo_metadesc', $user->ID ) ); ?></textarea>
		</td>
	</tr>
	<?php if ( $options['usemetakeywords'] === true ) { ?>
		<tr>
			<th scope="row">
				<label
					for="wpseo_author_metakey"><?php esc_html_e( 'Meta keywords to use for Author page', 'wordpress-seo' ); ?></label>
			</th>
			<td>
				<input class="regular-text" type="text" id="wpseo_author_metakey"
				       name="wpseo_author_metakey"
				       value="<?php echo esc_attr( get_the_author_meta( 'wpseo_metakey', $user->ID ) ); ?>"/>
			</td>
		</tr>
	<?php } ?>
	<tr>
		<td></td>
		<td>
			<input class="checkbox double" type="checkbox" id="wpseo_author_exclude"
			       name="wpseo_author_exclude"
			       value="on" <?php echo ( get_the_author_meta( 'wpseo_excludeauthorsitemap', $user->ID ) === 'on' ) ? 'checked' : ''; ?> />
			<label class="yoast-label-strong"
				for="wpseo_author_exclude"><?php esc_html_e( 'Exclude user from Author-sitemap', 'wordpress-seo' ); ?></label>
		</td>
	</tr>

	<?php if ( $options['keyword-analysis-active'] === true ) { ?>
		<tr>
			<td></td>
			<td>
				<input class="checkbox double" type="checkbox" id="wpseo_keyword_analysis_disable"
				       name="wpseo_keyword_analysis_disable" aria-describedby="wpseo_keyword_analysis_disable_desc"
				       value="on" <?php echo ( get_the_author_meta( 'wpseo_keyword_analysis_disable', $user->ID ) === 'on' ) ? 'checked' : ''; ?> />
				<label class="yoast-label-strong"
					for="wpseo_keyword_analysis_disable"><?php esc_html_e( 'Disable SEO analysis', 'wordpress-seo' ); ?></label>
				<p class="description" id="wpseo_keyword_analysis_disable_desc">
					<?php esc_html_e( 'Removes the keyword tab from the metabox and disables all SEO-related suggestions.', 'wordpress-seo' ); ?>
				</p>
			</td>
		</tr>

	<?php } ?>

	<?php if ( $options['content-analysis-active'] === true ) { ?>
		<tr>
			<td></td>
			<td>
				<input class="checkbox double" type="checkbox" id="wpseo_content_analysis_disable"
				       name="wpseo_content_analysis_disable" aria-describedby="wpseo_content_analysis_disable_desc"
				       value="on" <?php echo ( get_the_author_meta( 'wpseo_content_analysis_disable', $user->ID ) === 'on' ) ? 'checked' : ''; ?> />
				<label class="yoast-label-strong"
					for="wpseo_content_analysis_disable"><?php esc_html_e( 'Disable readability analysis', 'wordpress-seo' ); ?></label>
				<p class="description" id="wpseo_content_analysis_disable_desc">
					<?php esc_html_e( 'Removes the readability tab from the metabox and disables all readability-related suggestions.', 'wordpress-seo' ); ?>
				</p>
			</td>
		</tr>
	<?php } ?>
</table>
<br/><br/>